# Hive Offline Config Tool

This package provides utilities to automatically copy and execute Hive config scripts on a remote device via SSH.  
It supports both **Bash** (Linux/macOS) and **PowerShell** (Windows) environments.

---

## 📁 Folder Structure

```
hive_offline_config_tool/
│
├── run_hive_config.sh             # Bash version
├── run_hive_config.ps1            # PowerShell version
├── scripts/                       # Place your local scripts here
└── README.md                      # This file
```

## 🐝 Preparation on Hive

Use the button on the Node config page on Hive to download the device config script and drop it into the `scripts/` folder before running the automation.

---

## 🧩 Description

Both versions perform the same task:

1. Look inside the `./scripts/` folder (non-recursive).
2. Find all valid script files (e.g., `.sh`, `.bash`, `.py`, or executable files).
3. Sort them by **modification time** (newest first).
4. Copy the latest one (by default) — or more if you set `MAX_SCRIPTS` — to a remote device via `scp`.
5. Execute it remotely over SSH.
6. Collect output and exit code back to the local machine.
7. Optionally clean up the remote files after execution.
8. Export offline metadata (`HIVE_OFFLINE=1` plus the detected controller IP) so the script can verify that the PC running the tool is still reachable.

---

## 🖥️ Bash Version Usage

### Prerequisites

- `ssh` and `scp` must be installed.
- SSH access to the target device (with passwordless key or password prompt).

### Example

```bash
chmod +x run_hive_config.sh
./run_hive_config.sh <REMOTE_IP>
```

### Environment Variables

| Variable       | Description                                 | Default   |
| -------------- | ------------------------------------------- | --------- |
| `REMOTE_USER`  | SSH username                                | `root`    |
| `REMOTE_PORT`  | SSH port                                    | `22`      |
| `REMOTE_DIR`   | Remote directory to copy and execute in     | `/tmp`    |
| `CLEANUP`      | Whether to remove remote files (`yes`/`no`) | `yes`     |
| `SSH_OPTS`     | Extra ssh options (default enables `ssh-rsa`) | `-oHostKeyAlgorithms=+ssh-rsa -oPubkeyAcceptedAlgorithms=+ssh-rsa` |
| `SCP_OPTS`     | Extra scp options (default enables `ssh-rsa`) | `-oHostKeyAlgorithms=+ssh-rsa -oPubkeyAcceptedAlgorithms=+ssh-rsa` |
| `TIMEOUT_SECS` | Per-script timeout in seconds               | `900`     |
| `MAX_SCRIPTS`  | How many newest scripts to run              | `1`       |
| `CONFIG_HOST`  | Override controller PC IP advertised to the device | _(auto)_ |

> The tool automatically tries to discover the IP address that reaches the remote device (via `ip route`/`ip addr show` on Linux or `Test-NetConnection`/`Get-NetIPConfiguration` on Windows). The value is passed to the remote script through the `CONFIG_HOST` env var alongside `HIVE_OFFLINE=1`, allowing the script to run connectivity checks against the PC before committing configuration instead of falling back to `127.0.0.1`.

> To support legacy BusyBox implementations that only ship `scp` (without `sftp-server`), both launchers force the `-O` flag so SCP uses the classic protocol. Remove `-O` via `SCP_OPTS` if your environment requires SFTP mode.

Console output is streamed live while each script run is archived under `remote_run_results/remote_run_results_<timestamp>/`, giving you both immediate feedback and files you can share with colleagues.

---

## 🪟 PowerShell Version Usage

### Prerequisites

- `ssh` and `scp` must be available in your PATH (e.g., from OpenSSH for Windows).
- PowerShell 5.1+ or PowerShell Core 7+.

### Example

```powershell
.\run_hive_config.ps1 -RemoteIP 192.168.1.10
```

You can set optional environment variables before execution, similar to the Bash version.

---

## 🧠 Tips

- By default, only the **latest script** is executed.
- The script stores logs in a timestamped folder named `remote_run_results_<timestamp>/`.

---

## ⚠️ Security Note

This script disables strict host key checking to simplify automation:

```
-o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null
```

For production or secure environments, you should **remove or adjust** these options to avoid man-in-the-middle risks.

---
